/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.driver.oui.ui.DefaultAlertHandler;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMAlert;
import oracle.sysman.oii.oiif.oiifo.OiifoOCMInterfaceManager;

public class OCMDetailsAction
extends DefaultAction {
    private static final Logger logger = Logger.getLogger(OCMDetailsAction.class.getName());

    public OCMDetailsAction() {
        Application application = Application.getInstance();
        final boolean graphical = application.getUIType() == UIType.GRAPHICAL;
        OiifoOCMInterfaceManager manager = OiifoOCMInterfaceManager.getInstance((!graphical ? 1 : 0) != 0);
        manager.setAlertHandler(new OiifoIOCMAlert(){
            private DefaultAlertHandler alertHandler = new DefaultAlertHandler(null);

            public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
                int returnCode = 2;
                Level level = Level.INFO;
                switch (severity) {
                    case 20: {
                        level = Level.SEVERE;
                        break;
                    }
                    case 10: {
                        level = Level.WARNING;
                    }
                }
                if (graphical) {
                    returnCode = this.alertHandler.displayAlert(title, message, alertType, userChoices, defaultChoice, severity);
                } else {
                    System.out.printf("[%s] - %s\n", level, message);
                    if (level == Level.WARNING) {
                        returnCode = 1;
                    }
                }
                logger.log(level, message);
                return returnCode;
            }
        });
    }
}

